/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibabiz.component.filters;

import cn.com.duibabiz.component.filters.DuibaHostConfig;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DuibaHostFilter
implements Filter {
    @Autowired
    private DuibaHostConfig duibaHostConfig;
    private static final Logger LOG = LoggerFactory.getLogger(DuibaHostFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            String host = null;
            try {
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                host = request.getHeader("host");
                this.replaceAccessLogHost(host);
            }
            catch (Exception e) {
                LOG.error("DuibaHostFilter process error, host={},message={}", (Object)host, (Object)e);
            }
        }
    }

    private void replaceAccessLogHost(String host) {
        if (host == null) {
            LOG.info("DuibaHostFilter host is null");
            return;
        }
        List<String> fromDomains = this.duibaHostConfig.getFromDomains();
        for (String fromDomain : fromDomains) {
            if (StringUtils.isBlank((String)fromDomain) || !host.endsWith(fromDomain.trim())) continue;
            AccessLogFilter.putOverWritePair((String)"host", (String)this.duibaHostConfig.getToDomain());
            return;
        }
    }

    public void destroy() {
    }
}

