package cn.com.duiba.boot.utils;

import org.springframework.core.env.*;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SpringEnvironmentUtils {

    /**
     * 从spring的Environment获得扁平化的所有key value对
     * @param environment
     * @return
     */
    public static LinkedHashMap<String, Object> getFlatEnvironments(Environment environment) {
        final LinkedHashMap<String, Object> properties = new LinkedHashMap<>();
        for (Iterator it = ((AbstractEnvironment) environment).getPropertySources().iterator(); it.hasNext(); ) {
            PropertySource propertySource = (PropertySource) it.next();
            if (propertySource instanceof EnumerablePropertySource) {
                for (String key : ((EnumerablePropertySource) propertySource).getPropertyNames()) {
                    properties.putIfAbsent(key, propertySource.getProperty(key));
                }
            }
            if (propertySource instanceof PropertiesPropertySource) {
                for (Map.Entry<String, Object> e : ((MapPropertySource) propertySource).getSource().entrySet()) {
                    properties.putIfAbsent(e.getKey(), e.getValue());
                }
            }
            if (propertySource instanceof CompositePropertySource) {
                for (Map.Entry<String, Object> e : getPropertiesInCompositePropertySource((CompositePropertySource) propertySource).entrySet()) {
                    properties.putIfAbsent(e.getKey(), e.getValue());
                }
            }
        }
        return properties;
    }

    private static LinkedHashMap<String, Object> getPropertiesInCompositePropertySource(CompositePropertySource compositePropertySource) {
        final LinkedHashMap<String, Object> properties = new LinkedHashMap<>();
        compositePropertySource.getPropertySources().forEach(propertySource -> {
            if (propertySource instanceof EnumerablePropertySource) {
                for (String key : ((EnumerablePropertySource) propertySource).getPropertyNames()) {
                    properties.putIfAbsent(key, propertySource.getProperty(key));
                }
            }
            if (propertySource instanceof MapPropertySource) {
                for (Map.Entry<String, Object> e : ((MapPropertySource) propertySource).getSource().entrySet()) {
                    properties.putIfAbsent(e.getKey(), e.getValue());
                }
            }
            if (propertySource instanceof CompositePropertySource) {
                for (Map.Entry<String, Object> e : getPropertiesInCompositePropertySource((CompositePropertySource) propertySource).entrySet()) {
                    properties.putIfAbsent(e.getKey(), e.getValue());
                }
            }
        });
        return properties;
    }
}
