/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    public static final String ANYHOST = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile String LocalIP = null;

    public static String getLocalIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (LocalIP != null) {
            return LocalIP;
        }
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidLocalAddress(localAddress)) {
                return localAddress.getHostAddress();
            }
        }
        catch (Throwable e) {
            log.warn("Failed to retriving ip address, " + e.getMessage(), e);
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error(" NetworkInterface.getNetworkInterfaces error", (Throwable)e);
            return null;
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                LocalIP = ip.getHostAddress();
                return LocalIP;
            }
        }
        return LocalIP;
    }

    private static boolean isValidLocalAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress() || !address.isSiteLocalAddress()) {
            return false;
        }
        if (address instanceof Inet6Address) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }
}

