/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringEnvironmentUtils {
    public static LinkedHashMap<String, Object> getFlatEnvironments(Environment environment) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (PropertySource propertySource : ((AbstractEnvironment)environment).getPropertySources()) {
            if (propertySource instanceof EnumerablePropertySource) {
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    properties.putIfAbsent(key, propertySource.getProperty(key));
                }
            }
            if (propertySource instanceof PropertiesPropertySource) {
                for (Map.Entry entry : ((Map)((MapPropertySource)propertySource).getSource()).entrySet()) {
                    properties.putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            }
            if (!(propertySource instanceof CompositePropertySource)) continue;
            for (Map.Entry entry : SpringEnvironmentUtils.getPropertiesInCompositePropertySource((CompositePropertySource)propertySource).entrySet()) {
                properties.putIfAbsent((String)entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    private static LinkedHashMap<String, Object> getPropertiesInCompositePropertySource(CompositePropertySource compositePropertySource) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        compositePropertySource.getPropertySources().forEach(propertySource -> {
            if (propertySource instanceof EnumerablePropertySource) {
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    properties.putIfAbsent(key, propertySource.getProperty(key));
                }
            }
            if (propertySource instanceof MapPropertySource) {
                for (Map.Entry entry : ((Map)((MapPropertySource)propertySource).getSource()).entrySet()) {
                    properties.putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            }
            if (propertySource instanceof CompositePropertySource) {
                for (Map.Entry entry : SpringEnvironmentUtils.getPropertiesInCompositePropertySource((CompositePropertySource)propertySource).entrySet()) {
                    properties.putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            }
        });
        return properties;
    }
}

