package cn.com.duiba.boot.perftest;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class PerfTestUtils {

    public static final String PERF_TEST_KEY = "_duibaPerf";

    public static final String IS_PERF_TEST_MODE_HEADER_KEY = "isPerfTestMode";

    /**
     * 检测到包含_duibaPerf=1参数的url(或cookie中有_duibaPerf=1,或header中包含_duibaPerf=1)则认为是压测请求
     * @param request
     * @return
     */
    public static boolean isPerfTestRequest(HttpServletRequest request){
        boolean isTestMode = false;
        String testInParameter = request.getParameter(PERF_TEST_KEY);
        if(testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))){
            isTestMode = true;
        }else{
            Cookie[] cookies = request.getCookies();
            if(cookies != null) {
                for (Cookie cookie : cookies) {
                    if(PERF_TEST_KEY.equals(cookie.getName()) && ("1".equals(cookie.getValue()) || "true".equals(cookie.getValue()))){
                        isTestMode = true;
                    }
                }
            }
        }

        if(!isTestMode){
            String perfTestHeader = request.getHeader(PERF_TEST_KEY);
            if(perfTestHeader != null && ("1".equals(perfTestHeader) || "true".equals(perfTestHeader))){
                isTestMode = true;
            }
        }

        if(!isTestMode){
            //feign 发起的http压测请求头中会带有isPerfTestMode=true
            if("true".equals(request.getHeader(IS_PERF_TEST_MODE_HEADER_KEY))){
                isTestMode = true;
            }
        }

        return isTestMode;
    }
}
