/**
 * Copyright 2012 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.duiba.boot.netflix.feign.hystrix;

import java.lang.annotation.*;

/**
 * This annotation allows specify Hystrix command properties in the following format:
 * property name = property value.
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Repeatable(FeignHystrixProperty.FeignHystrixPropertys.class)
public @interface FeignHystrixProperty {

    /**
     * Property name.
     *
     * @return name
     */
    String name();

    /**
     * Property value
     *
     * @return value
     */
    String value();

    @Target({ElementType.METHOD, ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface FeignHystrixPropertys{
        FeignHystrixProperty[] value();
    }
}
