package cn.com.duiba.boot.netflix.ribbon;

import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;

import java.util.function.Predicate;

/**
 * 过滤ribbon ServerList的接口, 使用者只要实现此接口，并注册为spring bean，即可被自动应用。
 * 和RibbonServerListFilter的作用类似，只是RibbonServerListFilter的参数是多个Server，而RibbonServerPredicate的参数是一个Server
 *
 * <br/>
 * 实现test方法时，return false表示改服务器需要被过滤掉。
 */
public interface RibbonServerPredicate extends Predicate<DiscoveryEnabledServer> {

}
