package cn.com.duiba.boot.perftest;

/**
 * 本类只供框架内部使用
 * Created by guoyanfei .
 * 2018/11/5 .
 */
public class InternalPerfTestContext {

    /**
     * 判断当前是否是压测请求
     *
     * @return
     */
    public static boolean isCurrentInPerfTestMode(){
        return PerfTestContext.isCurrentInPerfTestMode();
    }

    /**
     * 获取当前压测的场景id
     * @return
     */
    public static String getCurrentSceneId() {
        return PerfTestContext.getCurrentSceneId();
    }

    /**
     * 独立容器集群压测
     * @return
     */
    public static boolean isTestCluster() {
        return PerfTestContext.isTestCluster();
    }

    /**
     * 标记为压测请求，需要设置场景id
     * 注意：除非特殊情况，否则框架使用者不应该调用此接口
     * @param sceneId
     * @param isTestCluster
     */
    public static void markAsPerfTest(String sceneId, boolean isTestCluster) {
        PerfTestContext.markAsPerfTest(sceneId, isTestCluster);
    }

    /**
     * 标记为生产请求
     * 注意：除非特殊情况，否则框架使用者不应该调用此接口
     */
    public static void markAsNormal() {
        PerfTestContext.markAsNormal();
    }
}
