package cn.com.duiba.boot.flowreplay;

import java.lang.annotation.*;

/**
 * 引流回归功能专用的注解
 * 业务代码中，可能存在这样的一些操作：
 *      public String test(String key) {
 *         String token = System.currentTimeMillis();
 *         redisClient.set(key, token);
 *         return value;
 *     }
 * 这时候，按照正常的录制流程，redisClient.set(key, token) 这个操作会被录制下来
 * 由于很难保证录制和回放的时候，系统时间完全一致。所以回放的时候这个操作的token和录制的时候的token基本上不可能相同
 * 这时候这个操作就没法mock，进而这个用例就会回放失败（对于System.currentTimeMillis()操作的单独录制和回放也比较难实现）
 *
 * 为了不让类似的操作影响整个用例的回放结果，业务线同学可以在方法上加上这个注解，代码如下
 *     @FlowReplayCustomizeSpan
 *     public String test(String key) {
 *         String value = System.currentTimeMillis();
 *         redisClient.set(key, value);
 *         return value;
 *     }
 * 加上这个注解后，test整个方法会作为一个录制和回放的整体。也就是说，回放的时候，不会再去调用test方法内部的逻辑（不会再调用System.currentTimeMillis()）
 * 直接mock test方法的结果，这样回放流程就可以顺利进行
 *
 * 注意：加了@FlowReplayCustomizeSpan注解的方法，应当是该bean中被外部调用的方法，如果内部其他方法调用该方法，该注解不会生效
 * Created by guoyanfei .
 * 2019-05-23 .
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface FlowReplayCustomizeSpan {
}
