package cn.com.duiba.boot.perftest;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

public final class PerfTestContext {
    private static final Logger logger = LoggerFactory.getLogger(PerfTestContext.class);
    private PerfTestContext(){}

    public static volatile boolean _perfDebug = false;

    //当前线程是否在压测模式
    private Boolean isPerfTestMode;
    //debug模式使用，记录设置压测标记时的调用堆栈，方便排查错误
    private StackTraceElement[] stackTraceElements;
    //debug模式使用，记录设置压测标记时的时间，方便排查错误
    private long timestamp;

    /**
     * 获得最近设置压测标记为true时的时间戳，需要在启动脚本中增加-DperfDebug=true
     * @return
     */
    public long getTimestamp() {
        return timestamp;
    }

    /**
     * 获得最近设置压测标记为true时的方法栈，需要在启动脚本中增加-DperfDebug=true
     * @return
     */
    public StackTraceElement[] getStackTraceElements() {
        return stackTraceElements;
    }

    private static class TransmittableThreadLocalHolder{
        protected static final TransmittableThreadLocal<PerfTestContext> threadLocal2PressureTest = new TransmittableThreadLocal<>();
    }

    /**
     * 判断当前是否是压测请求
     *
     * @return
     */
    public static boolean isCurrentInPerfTestMode(){
        PerfTestContext c = TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
        return c != null && c.isPerfTestMode != null && c.isPerfTestMode == true;
    }

    /**
     * 设置是否压测请求，框架使用者不应该调用此接口
     * @param val
     */
    public static void _setPerfTestMode(Boolean val) {
        if(val != null && val) {
            PerfTestContext c = new PerfTestContext();
            c.isPerfTestMode = val;
            if(_perfDebug) {
                c.stackTraceElements = Thread.currentThread().getStackTrace();
                c.timestamp = System.currentTimeMillis();
            }
            TransmittableThreadLocalHolder.threadLocal2PressureTest.set(c);
        }else{
            TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
        }
    }

    public static PerfTestContext _currentContext(){
        return TransmittableThreadLocalHolder.threadLocal2PressureTest.get();
    }

    public static void debugInfo(String typeName){
        if (logger.isDebugEnabled()) {
            Arrays.stream(Thread.currentThread().getStackTrace()).filter(x->x.getClassName().startsWith("cn.com.duiba.")).forEach(x->
                    logger.debug("Perf {} From {}:{}:{}",typeName, x.getClassName(),x.getMethodName(),x.getLineNumber())
            );
        }
    }
}
