package cn.com.duiba.boot.netflix.ribbon;


import com.netflix.loadbalancer.Server;

import java.util.List;

/**
 * 过滤ribbon ServerList的接口, 使用者只要实现此接口，并注册为spring bean，即可被自动应用。
 *
 * <br/>
 */
public interface RibbonServerListFilter {

    /**
     * 此方法用于过滤掉不需要的服务器
     * @param serverList 原始服务器列表
     * @param key 可以根据这个key决定筛选出不同的服务器列表，目前在压测场景中被使用
     * @return 可用的服务器列表
     */
    List<Server> filter(List<Server> serverList, Object key);
}
