package cn.com.duiba.wolf.cache;

import java.util.concurrent.TimeUnit;

/**
 * 缓存客户端接口，该接口只提供缓存相关操作,并提供高度抽象的接口,只应该使用该接口进行缓存相关操作。
 *
 * Created by wenqi.huang on 2017/1/14.
 */
public interface AdvancedCacheClient {

    <T> T get(String key);

    /**
     * 设置值,如果value为null不会放入缓存
     *
     * @param key
     * @param value
     * @param exp
     * @param timeUnit
     */
    boolean set(String key, Object value, int exp, TimeUnit timeUnit);

    /**
     * 根据Key读取Cache中的值,当值为null时会自动调用cacheLoader.load方法获得值并set进缓存
     *
     * @param key
     * @param exp
     * @param timeUnit
     * @param isCacheNull isCacheNull为true时, 如果cacheLoader.load得到null,则会把NullCache.NULL放入缓存,以减少对数据库的穿透,get时会判断如果是NullCache实例则直接返回null
     * @param cacheLoader
     * @param <T>
     * @return
     */
    <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, boolean isCacheNull, CacheLoader<T> cacheLoader);

    /**
     * 根据Key读取Cache中的值,当值为null时会自动调用cacheLoader.load方法获得值并set进缓存
     *
     * @param key
     * @param exp
     * @param timeUnit
     * @param cacheLoader
     * @param <T>
     * @return
     */
    <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, CacheLoader<T> cacheLoader);

    /**
     * 移除key
     *
     * @param key
     * @return
     */
    boolean remove(String key);

    /**
     * 移除多个key
     *
     * @param keys
     * @return
     */
    boolean remove(String... keys);

}
