/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.perftest;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public final class PerfTestUtils {
    public static final String PERF_TEST_KEY = "_duibaPerf";
    public static final String PERF_TEST_SCENE_ID_KEY = "_duibaPerfSceneId";
    public static final String PERF_TEST_CLUSTER = "_duibaPerfTestCluster";
    public static final String IS_PERF_TEST_MODE_HEADER_KEY = "isPerfTestMode";
    public static final String DUIBA_PERF_SCENE_ID = "duiba.perf.scene.id";

    private PerfTestUtils() {
    }

    public static boolean isPerfTestRequest(HttpServletRequest request) {
        String perfTestHeader;
        boolean isTestMode = PerfTestUtils.isPerfTestFromParameter(request);
        if (!isTestMode && (perfTestHeader = request.getHeader(PERF_TEST_KEY)) != null && ("1".equals(perfTestHeader) || "true".equals(perfTestHeader))) {
            isTestMode = true;
        }
        if (!isTestMode && "true".equals(request.getHeader(IS_PERF_TEST_MODE_HEADER_KEY))) {
            isTestMode = true;
        }
        return isTestMode;
    }

    public static String getPerfTestSceneId(HttpServletRequest request) {
        Cookie[] cookies;
        if (!PerfTestUtils.isPerfTestRequest(request)) {
            return null;
        }
        String sceneId = request.getParameter(PERF_TEST_SCENE_ID_KEY);
        if (StringUtils.isBlank((CharSequence)sceneId) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!PERF_TEST_SCENE_ID_KEY.equals(cookie.getName())) continue;
                sceneId = cookie.getValue();
            }
        }
        if (StringUtils.isBlank((CharSequence)sceneId)) {
            sceneId = request.getHeader(PERF_TEST_SCENE_ID_KEY);
        }
        return sceneId;
    }

    public static boolean isPerfTestCluster(HttpServletRequest request) {
        Cookie[] cookies;
        if (!PerfTestUtils.isPerfTestRequest(request)) {
            return false;
        }
        String isTestCluster = request.getParameter(PERF_TEST_CLUSTER);
        if (StringUtils.isBlank((CharSequence)isTestCluster) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!PERF_TEST_CLUSTER.equals(cookie.getName())) continue;
                isTestCluster = cookie.getValue();
            }
        }
        if (StringUtils.isBlank((CharSequence)isTestCluster)) {
            isTestCluster = request.getHeader(PERF_TEST_CLUSTER);
        }
        return "1".equals(isTestCluster) || "true".equals(isTestCluster);
    }

    private static boolean isPerfTestFromParameter(HttpServletRequest request) {
        boolean isTestMode = false;
        String testInParameter = request.getParameter(PERF_TEST_KEY);
        if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
            isTestMode = true;
        } else {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!PERF_TEST_KEY.equals(cookie.getName()) || !"1".equals(cookie.getValue()) && !"true".equals(cookie.getValue())) continue;
                    isTestMode = true;
                }
            }
        }
        return isTestMode;
    }

    public static String getThisServerDuibaPerfSceneId(ApplicationContext applicationContext) {
        return applicationContext.getEnvironment().getProperty(DUIBA_PERF_SCENE_ID);
    }
}

