/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.cache;

import cn.com.duiba.boot.cat.CatTools;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import cn.com.duiba.wolf.entity.Null;
import cn.com.duiba.wolf.log.DegradeLogger;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisCacheClient
implements AdvancedCacheClient {
    private static final Logger logger = DegradeLogger.wrap((Logger)LoggerFactory.getLogger(RedisCacheClient.class));
    private final RedisTemplate redisTemplate;
    private RedisSerializer<String> keyRedisSerializer = new StringRedisSerializer();
    private RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    public RedisCacheClient(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public <T> T get(String key) {
        T t = this.getInner(key);
        if (t != null && t instanceof Null) {
            return null;
        }
        return t;
    }

    @Override
    public boolean set(String key, Object value, final int timeout, final TimeUnit unit) {
        if (value == null) {
            return false;
        }
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) {
                    this.potentiallyUsePsetEx(connection);
                    return null;
                }

                public void potentiallyUsePsetEx(RedisConnection connection) {
                    if (!TimeUnit.MILLISECONDS.equals((Object)unit) || !this.failsafeInvokePsetEx(connection)) {
                        connection.setEx(rawKey, TimeoutUtils.toSeconds((long)timeout, (TimeUnit)unit), rawValue);
                    }
                }

                private boolean failsafeInvokePsetEx(RedisConnection connection) {
                    boolean failed = false;
                    try {
                        connection.pSetEx(rawKey, (long)timeout, rawValue);
                    }
                    catch (UnsupportedOperationException e) {
                        failed = true;
                    }
                    return !failed;
                }
            }, true);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            CatTools.log(e);
            return false;
        }
        return true;
    }

    private <T> T getInner(String key) {
        byte[] rawKey = this.rawKey(key);
        try {
            return (T)this.redisTemplate.execute(connection -> {
                byte[] valueBytes = connection.get(rawKey);
                return this.valueRedisSerializer.deserialize(valueBytes);
            }, true);
        }
        catch (Exception e) {
            logger.error("get key error:" + key, (Throwable)e);
            CatTools.log(e);
            return null;
        }
    }

    @Override
    public <T> T getWithCacheLoader(String key, int timeout, TimeUnit timeUnit, boolean isCacheNull, CacheLoader<T> cacheLoader) {
        T value = this.getInner(key);
        if (value == null) {
            value = cacheLoader.load();
            if (isCacheNull) {
                this.setWithNull(key, value, timeout, timeUnit);
            } else if (value != null) {
                this.set(key, value, timeout, timeUnit);
            }
        }
        if (value instanceof Null) {
            value = null;
        }
        return value;
    }

    protected void setWithNull(String key, Object value, int timeout, TimeUnit unit) {
        Object v = value;
        if (v == null) {
            v = Null.NULL;
        }
        this.set(key, v, timeout, unit);
    }

    @Override
    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, CacheLoader<T> cacheLoader) {
        return this.getWithCacheLoader(key, exp, timeUnit, false, cacheLoader);
    }

    @Override
    public boolean remove(String key) {
        String[] keys = new String[]{key};
        return this.remove(keys);
    }

    @Override
    public boolean remove(String ... keys) {
        byte[][] rawKeys = new byte[keys.length][];
        int i = 0;
        for (String key : keys) {
            byte[] rawKey = this.rawKey(key);
            rawKeys[i++] = rawKey;
        }
        try {
            this.redisTemplate.execute(connection -> {
                connection.del(rawKeys);
                return null;
            }, true);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            CatTools.log(e);
            return false;
        }
        return true;
    }

    private byte[] rawKey(String key) {
        return this.keyRedisSerializer.serialize((Object)key);
    }

    private byte[] rawValue(Object value) {
        return this.valueRedisSerializer.serialize(value);
    }
}

