package cn.com.duiba.boot.event;

import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;

/**
 * 主容器刷新final事件。
 * <br/>
 * 1.在MainContextRefreshedEvent之后发出。
 * 2.在DuibaEurekaAutoServiceRegistration之前发出。
 * <p>
 * 主要作用
 * 1.dubbo服务的暴露(通过注入BeanDefinition，覆盖DubboDeployApplicationListener，将注册时间修改为本事件)
 */
public class FinalContextRefreshedEvent extends ApplicationContextEvent {

    public FinalContextRefreshedEvent(ApplicationContext source) {
        super(source);
    }
}
