/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class JarVersionUtils {
    private JarVersionUtils() {
    }

    public static String getJarVersion(Class clazz) {
        Package pkg = clazz.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    public static boolean isJarVersionEqualOrGreaterThan(String currentVersion, String baseVersion) {
        if (StringUtils.isBlank((String)currentVersion) || StringUtils.isBlank((String)baseVersion)) {
            return false;
        }
        Integer[] currentVersionArr = JarVersionUtils.normalization(currentVersion);
        if (currentVersionArr == null) {
            return false;
        }
        Integer[] baseVersionArr = JarVersionUtils.normalization(baseVersion);
        if (baseVersionArr == null) {
            return false;
        }
        int minLen = Math.min(currentVersionArr.length, baseVersionArr.length);
        for (int i = 0; i < minLen; ++i) {
            if (currentVersionArr[i] > baseVersionArr[i]) {
                return true;
            }
            if (currentVersionArr[i] >= baseVersionArr[i]) continue;
            return false;
        }
        return currentVersionArr.length >= baseVersionArr.length;
    }

    private static Integer[] normalization(String v) {
        if (v.contains("-")) {
            v = v.substring(0, v.indexOf(45));
        }
        String[] vs = StringUtils.split((String)v, (char)'.');
        ArrayList<Integer> vsList = new ArrayList<Integer>();
        for (int i = 0; i < vs.length; ++i) {
            String v1 = vs[i];
            if (JarVersionUtils.isInteger(v1)) {
                vsList.add(Integer.parseInt(v1));
                continue;
            }
            if (i >= vs.length - 1) continue;
            return null;
        }
        return vsList.toArray(new Integer[vsList.size()]);
    }

    private static boolean isInteger(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

