/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.perftest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

public final class ReactivePerfTestUtils {
    private ReactivePerfTestUtils() {
    }

    public static boolean isPerfTestRequest(ServerHttpRequest request) {
        String perfTestHeader;
        boolean isTestMode = ReactivePerfTestUtils.isPerfTestFromParameter(request);
        if (!isTestMode && (perfTestHeader = request.getHeaders().getFirst("_duibaPerf")) != null && ("1".equals(perfTestHeader) || "true".equals(perfTestHeader))) {
            isTestMode = true;
        }
        if (!isTestMode && "true".equals(request.getHeaders().getFirst("isPerfTestMode"))) {
            isTestMode = true;
        }
        return isTestMode;
    }

    public static String getPerfTestSceneId(ServerHttpRequest request) {
        HttpCookie cookie;
        if (!ReactivePerfTestUtils.isPerfTestRequest(request)) {
            return null;
        }
        String sceneId = (String)request.getQueryParams().getFirst((Object)"_duibaPerfSceneId");
        if (StringUtils.isBlank((CharSequence)sceneId) && (cookie = (HttpCookie)request.getCookies().getFirst((Object)"_duibaPerfSceneId")) != null) {
            sceneId = cookie.getValue();
        }
        if (StringUtils.isBlank((CharSequence)sceneId)) {
            sceneId = request.getHeaders().getFirst("_duibaPerfSceneId");
        }
        return sceneId;
    }

    public static boolean isPerfTestCluster(ServerHttpRequest request) {
        HttpCookie cookie;
        if (!ReactivePerfTestUtils.isPerfTestRequest(request)) {
            return false;
        }
        String isTestCluster = (String)request.getQueryParams().getFirst((Object)"_duibaPerfTestCluster");
        if (StringUtils.isBlank((CharSequence)isTestCluster) && (cookie = (HttpCookie)request.getCookies().getFirst((Object)"_duibaPerfTestCluster")) != null) {
            isTestCluster = cookie.getValue();
        }
        if (StringUtils.isBlank((CharSequence)isTestCluster)) {
            isTestCluster = request.getHeaders().getFirst("_duibaPerfTestCluster");
        }
        return "1".equals(isTestCluster) || "true".equals(isTestCluster);
    }

    private static boolean isPerfTestFromParameter(ServerHttpRequest request) {
        boolean isTestMode = false;
        String testInParameter = (String)request.getQueryParams().getFirst((Object)"_duibaPerf");
        if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
            isTestMode = true;
        } else {
            HttpCookie cookie = (HttpCookie)request.getCookies().getFirst((Object)"_duibaPerf");
            if (cookie != null && ("1".equals(cookie.getValue()) || "true".equals(cookie.getValue()))) {
                isTestMode = true;
            }
        }
        return isTestMode;
    }
}

