/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.util.IPAddressUtil;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    public static final String ANYHOST = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile String localIP = null;

    private NetUtils() {
    }

    public static String getLocalIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (localIP != null) {
            return localIP;
        }
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidLocalAddress(localAddress)) {
                localIP = localAddress.getHostAddress();
                return localIP;
            }
        }
        catch (Throwable e) {
            log.warn("Failed to retriving ip address, " + e.getMessage(), e);
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error("getLocalIp error", (Throwable)e);
            return null;
        }
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(58) != -1) continue;
                localIP = ip.getHostAddress();
                return localIP;
            }
        }
        return localIP;
    }

    private static boolean isValidLocalAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress() || !address.isSiteLocalAddress()) {
            return false;
        }
        if (address instanceof Inet6Address) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static boolean isLanIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return NetUtils.isLanIp(addr);
    }

    private static boolean isLanIp(byte[] addr) {
        if (addr == null || addr.length < 2) {
            return false;
        }
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        if (b0 == 10) {
            return true;
        }
        if (b0 == -84 && b1 >= 16 && b1 <= 31) {
            return true;
        }
        return b0 == -64 && b1 == -88;
    }
}

