package cn.com.duiba.boot.ext.javaagent.main;

import cn.com.duiba.boot.ext.javaagent.plugin.AbstractClassEnhancePluginDefine;
import cn.com.duiba.boot.ext.javaagent.plugin.PluginBootstrap;
import cn.com.duiba.boot.ext.javaagent.plugin.PluginFinder;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.utility.JavaModule;

import java.lang.instrument.Instrumentation;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * 查找agent-plugin下配置的插件进行拦截,注入代码到相应的类(这个类必须被AppClassLoader加载，否则会报错)
 */
public class PluginAgent {
    private static final Logger logger = Logger.getLogger(PluginAgent.class.getName());

    public static void agentmain(String args, Instrumentation instrumentation) {

//        System.out.println("currentClassLoader:"+Thread.currentThread().getContextClassLoader());
//
//        Thread.currentThread().setContextClassLoader(org.springframework.boot.SpringApplication.class.getClassLoader());

        final PluginFinder pluginFinder = new PluginFinder(new PluginBootstrap().loadPlugins());
        new AgentBuilder.Default().type(pluginFinder.buildMatch()).transform(new AgentBuilder.Transformer() {
            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription,
                                                    ClassLoader classLoader, JavaModule module) {
                AbstractClassEnhancePluginDefine pluginDefine = pluginFinder.find(typeDescription, classLoader);
                if (pluginDefine != null) {
                    DynamicType.Builder<?> newBuilder = pluginDefine.define(typeDescription.getTypeName(), builder, classLoader);
                    if (newBuilder != null) {
                        if(logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, "Finish the prepare stage for " + typeDescription.getName());
                        }
                        return newBuilder;
                    }
                }

                logger.info("Matched class " + typeDescription.getTypeName() + ", but ignore by finding mechanism.");
                return builder;
            }
        }).with(new AgentBuilder.Listener() {
            @Override
            public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {

            }

            @Override
            public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                         boolean loaded, DynamicType dynamicType) {
                if(logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO,"On Transformation class " + typeDescription.getName());
                }
            }

            @Override
            public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module,
                                  boolean loaded) {

            }

            @Override
            public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded,
                                Throwable throwable) {
                if(logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Failed to enhance class " + typeName, throwable);
                }
            }

            @Override
            public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            }
        }).installOn(instrumentation);
    }
}
