/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.javaagent.plugin;

import cn.com.duiba.boot.ext.javaagent.plugin.PluginException;
import cn.com.duiba.boot.ext.javaagent.plugin.WitnessClassFinder;
import cn.com.duiba.boot.ext.javaagent.plugin.match.ClassMatch;
import cn.com.duiba.boot.ext.javaagent.plugin.util.StringUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.dynamic.DynamicType;

public abstract class AbstractClassEnhancePluginDefine {
    private final Logger logger = Logger.getLogger(AbstractClassEnhancePluginDefine.class.getName());

    public DynamicType.Builder<?> define(String transformClassName, DynamicType.Builder<?> builder, ClassLoader classLoader) throws PluginException {
        String[] witnessClasses;
        String interceptorDefineClassName = this.getClass().getName();
        if (StringUtil.isEmpty(transformClassName)) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning("classname of being intercepted is not defined by " + interceptorDefineClassName);
            }
            return null;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("prepare to enhance class " + transformClassName + " by " + interceptorDefineClassName);
        }
        if ((witnessClasses = this.witnessClasses()) != null) {
            for (String witnessClass : witnessClasses) {
                if (WitnessClassFinder.INSTANCE.exist(witnessClass, classLoader)) continue;
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning("enhance class " + transformClassName + " by plugin " + interceptorDefineClassName + " is not working. Because witness class " + witnessClass + " is not existed.");
                }
                return null;
            }
        }
        DynamicType.Builder<?> newClassBuilder = this.enhance(transformClassName, builder, classLoader);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("enhance class " + transformClassName + " by " + interceptorDefineClassName + " completely.");
        }
        return newClassBuilder;
    }

    protected abstract DynamicType.Builder<?> enhance(String var1, DynamicType.Builder<?> var2, ClassLoader var3) throws PluginException;

    protected abstract ClassMatch enhanceClass();

    protected String[] witnessClasses() {
        return new String[0];
    }
}

