/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.javaagent.plugin.match;

import cn.com.duiba.boot.ext.javaagent.plugin.match.ClassMatch;
import cn.com.duiba.boot.ext.javaagent.plugin.match.IndirectMatch;
import java.util.ArrayList;
import java.util.Arrays;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodAnnotationMatch
implements IndirectMatch {
    private String[] annotations;

    private MethodAnnotationMatch(String[] annotations) {
        if (annotations == null || annotations.length == 0) {
            throw new IllegalArgumentException("annotations is null");
        }
        this.annotations = annotations;
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction junction = null;
        for (String annotation : this.annotations) {
            junction = junction == null ? this.buildEachAnnotation(annotation) : junction.and((ElementMatcher)this.buildEachAnnotation(annotation));
        }
        junction = ElementMatchers.declaresMethod(junction).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
        return junction;
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        for (MethodDescription.InDefinedShape methodDescription : typeDescription.getDeclaredMethods()) {
            ArrayList<String> annotationList = new ArrayList<String>(Arrays.asList(this.annotations));
            AnnotationList declaredAnnotations = methodDescription.getDeclaredAnnotations();
            for (AnnotationDescription annotation : declaredAnnotations) {
                annotationList.remove(annotation.getAnnotationType().getActualName());
            }
            if (!annotationList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private ElementMatcher.Junction buildEachAnnotation(String annotationName) {
        return ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)annotationName));
    }

    public static ClassMatch byMethodAnnotationMatch(String[] annotations) {
        return new MethodAnnotationMatch(annotations);
    }
}

