package cn.com.duiba.boot.ext.autoconfigure.cat;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.store.DataStore;
import com.alibaba.dubbo.registry.dubbo.DubboRegistry;
import net.rubyeye.xmemcached.MemcachedClient;

import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;
import cn.com.duiba.catmonitor.mybatis.CatMybatisPlugin;
import cn.com.duiba.wolf.cache.XMemcacheClient;
import cn.com.duiba.wolf.redis.RedisClient;

import com.dianping.cat.Cat;
import com.dianping.cat.servlet.CatFilter;

/**
 * Created by wenqi.huang on 2016/11/7.
 */
@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
public class CatAutoConfiguration {

    //ConditionalOnClass这个注解必须加在类上，如果加在方法上的话，会因为找不到这些类而报错：https://github.com/spring-projects/spring-boot/issues/1733
    @Configuration
    @ConditionalOnClass({Servlet.class, FilterRegistrationBean.class, CatFilter.class})
    @ConditionalOnWebApplication
    public static class CatHttpFilterConfiguration{
        /**
         * 注入cat监控的Filter
         * @return
         */
        @Bean
        public FilterRegistrationBean catHttpFilterConfigurer(){
            CatFilter catFilter = new CatFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter(catFilter);
            List<String> urlPatterns=new ArrayList<String>();
            urlPatterns.add("/*");//拦截路径，可以添加多个
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
            registrationBean.setOrder(1);
            return registrationBean;
        }
    }

    @Configuration
    @ConditionalOnClass({SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class,CatMybatisPlugin.class})
    public static class MyBatisPostProcessorConfiguration{

        /**
         * 声明后置处理器，spring全部bean初始化完成后调用，给所有SqlSessionBean注入CatMybatisPlugin plugin，监控sql的执行
         * @return
         */
        @Bean
        public BeanPostProcessor myBatisPostProcessorConfigurer(){
            return new BeanPostProcessor() {
                @Override
                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                	SqlSessionFactory s = null;
                    if(bean instanceof SqlSessionFactory){
                        s = (SqlSessionFactory)bean;
                    }
                    if(bean instanceof SqlSessionTemplate){
                        s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
                    }
                    if(s == null){
                        return bean;
                    }

                    boolean hasCatPlugin = false;
                    if(s.getConfiguration().getInterceptors() != null && !s.getConfiguration().getInterceptors().isEmpty()) {
                        for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                            if (plugin instanceof CatMybatisPlugin) {
                                hasCatPlugin = true;
                                break;
                            }
                        }
                    }else{
                    }

                    if (!hasCatPlugin) {
                        s.getConfiguration().addInterceptor(new CatMybatisPlugin());
                    }

                    return bean;
                }
            };
        }
    }
    
    @Configuration
    @ConditionalOnClass({RedisClient.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatRediscacheConfiguration{
    	
    	@Bean
    	public CatRediscachePlugin getCatCachePlugin(){
    		return new CatRediscachePlugin();
    	}
    	
    }

    /**
     * 加入aop，监控spring-data-redis执行耗时
     */
    @Configuration
    @ConditionalOnClass({JedisConnectionFactory.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatSpringDataRedisAspectConfiguration{

    	@Bean
    	public CatSpringDataRedisPlugin catSpringDataRedisAspectPlugin(){
    		return new CatSpringDataRedisPlugin();
    	}

    }

    @Configuration
    @ConditionalOnClass({XMemcacheClient.class, MemcachedClient.class, Cat.class, Aspect.class})
    public static class CatMemcacheConfiguration{
    	
    	@Bean
    	public CatMemcachePlugin getCatMemcachePlugin(){
    		return new CatMemcachePlugin();
    	}
    	
    }
    
    @Configuration
    @ConditionalOnClass({Cat.class})
    public static class InitCatServer implements ApplicationListener{

		@Override
		public void onApplicationEvent(ApplicationEvent arg0) {
			//初始化cat监控
			Cat.getManager().isCatEnabled();
		}
    	
    }

//    /**
//     * 监控dubbo线程池使用情况，给cat发送心跳来记录(Cat暂时不支持心跳功能，后面再完善)
//     */
//    @Configuration
//    @ConditionalOnClass({DubboRegistry.class, DataStore.class})
//    public static class DubboThreadPoolMonitorConfiguration {
//
//        @Bean(initMethod = "init", destroyMethod = "close")
//        public DubboThreadPoolMonitor onApplicationEvent() {
//            return new DubboThreadPoolMonitor();
//        }
//
//        public static class DubboThreadPoolMonitor extends Thread{
//
//            @Override
//            public void run() {
//                while(true){
//                    if(this.isInterrupted()){
//                        break;
//                    }
//
//                    doMonitor();
//
//                    try {
//                        Thread.sleep(60000);
//                    } catch (InterruptedException e) {
//                        break;
//                    }
//                }
//            }
//
//            private void doMonitor(){
//                DataStore dataStore = ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
//                Map<String, Object> executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
//
//                StringBuilder msg = new StringBuilder();
//                Status.Level level = Status.Level.OK;
//                for(Map.Entry<String, Object> entry : executors.entrySet()) {
//                    String port = entry.getKey();
//                    ExecutorService executor = (ExecutorService) entry.getValue();
//
//                    if (executor != null && executor instanceof ThreadPoolExecutor) {
//                        ThreadPoolExecutor tp = (ThreadPoolExecutor) executor;
//                        boolean ok = tp.getActiveCount() < tp.getMaximumPoolSize() - 1;
//                        Status.Level lvl = Status.Level.OK;
//                        if(!ok) {
//                            level = Status.Level.WARN;
//                            lvl = Status.Level.WARN;
//                        }
//
//                        if(msg.length() > 0) {
//                            msg.append(";");
//                        }
//                        msg.append("Pool status:" + lvl
//                                + ", max:" + tp.getMaximumPoolSize()
//                                + ", core:" + tp.getCorePoolSize()
//                                + ", largest:" + tp.getLargestPoolSize()
//                                + ", active:" + tp.getActiveCount()
//                                + ", task:" + tp.getTaskCount()
//                                + ", service port: " + port);
//                    }
//                }
//
//                //Cat.logHeartbeat("ThreadPool Info", "Dubbo ActiveThread", Message.SUCCESS,"");
//            }
//
//            public void init(){
//                super.start();
//            }
//
//            public void close(){
//                this.interrupt();
//            }
//        }
//
//    }

}
