/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.data.elasticsearch;

import cn.com.duiba.boot.ext.autoconfigure.data.elasticsearch.ElasticsearchProperties;
import cn.com.duiba.boot.ext.autoconfigure.data.elasticsearch.ElasticsearchTemplate;
import org.elasticsearch.client.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;

@Configuration
@ConditionalOnClass(value={Client.class, ElasticsearchTemplate.class})
@AutoConfigureAfter(value={ElasticsearchAutoConfiguration.class})
@AutoConfigureBefore(value={org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchDataAutoConfiguration.class})
@EnableConfigurationProperties(value={ElasticsearchProperties.class})
public class ElasticsearchDataAutoConfiguration {
    @Autowired
    private ElasticsearchProperties elasticsearchProperties;

    @Bean
    @ConditionalOnMissingBean
    public ElasticsearchTemplate elasticsearchTemplate(Client client, ElasticsearchConverter converter) {
        try {
            return new ElasticsearchTemplate(client, converter, this.elasticsearchProperties.getSearchTimeout());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

