/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.initserver;

import cn.com.duiba.boot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.web.context.WebApplicationContext;

public class ApplicationListenerForAsyncSpecified
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap;

    public ApplicationListenerForAsyncSpecified(Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap) {
        this.asyncProcessor2BeansMap = asyncProcessor2BeansMap;
    }

    public int getOrder() {
        return -2;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        if (!(context instanceof WebApplicationContext)) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(100, (ThreadFactory)new NamedThreadFactory("DuibaBootInitServerThread-"));
        int totalBean2ProcessCount = 0;
        for (Map<String, Object> beanMap : this.asyncProcessor2BeansMap.values()) {
            totalBean2ProcessCount += beanMap.size();
        }
        final CountDownLatch countDownLatch = new CountDownLatch(totalBean2ProcessCount);
        for (Map.Entry<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> entry : this.asyncProcessor2BeansMap.entrySet()) {
            Map<String, Object> beanMap = entry.getValue();
            final AsyncSpecifiedBeanPostProcessor processor = entry.getKey();
            for (final Map.Entry<String, Object> beanEntry : beanMap.entrySet()) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            processor.postProcessAfterInitialization(beanEntry.getValue(), (String)beanEntry.getKey());
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                });
            }
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        executorService.shutdown();
    }
}

