/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web;

import cn.com.duiba.wolf.threadpool.MonitorCallable;
import cn.com.duiba.wolf.threadpool.MonitorRunnable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;

public class ThreadPoolServletContainerCustomizer
implements EmbeddedServletContainerCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolServletContainerCustomizer.class);

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            TomcatEmbeddedServletContainerFactory factory = (TomcatEmbeddedServletContainerFactory)container;
            factory.setProtocol(DuibaHttp11NioProtocol.class.getName());
        }
    }

    private static class TomcatMonitorThreadPoolExecutor
    extends ThreadPoolExecutor {
        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        }

        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        public TomcatMonitorThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        public void execute(Runnable command) {
            super.execute((Runnable)new MonitorRunnable(command, this.getQueue()));
        }

        public <T> Future<T> submit(Callable<T> task) {
            return super.submit((Callable)new MonitorCallable(task, this.getQueue()));
        }

        public <T> Future<T> submit(Runnable task, T result) {
            return super.submit((Runnable)new MonitorRunnable(task, this.getQueue()), result);
        }

        public Future<?> submit(Runnable task) {
            return super.submit((Runnable)new MonitorRunnable(task, this.getQueue()));
        }
    }

    public static class DuibaHttp11NioProtocol
    extends Http11NioProtocol {
        private java.util.concurrent.ThreadPoolExecutor http11NioExecutor;
        private long executorTerminationTimeoutMillis;
        private String endpointName;

        public AbstractEndpoint getEndpointInner() throws InvocationTargetException, IllegalAccessException {
            Method endpointMethod = null;
            for (Class clazz = Http11NioProtocol.class; clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    endpointMethod = clazz.getDeclaredMethod("getEndpoint", null);
                    endpointMethod.setAccessible(true);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            AbstractEndpoint endpoint = (AbstractEndpoint)endpointMethod.invoke((Object)this, null);
            return endpoint;
        }

        private void createExecutor() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            AbstractEndpoint endpoint = this.getEndpointInner();
            this.executorTerminationTimeoutMillis = endpoint.getExecutorTerminationTimeoutMillis();
            this.endpointName = endpoint.getName();
            if (this.http11NioExecutor == null) {
                TaskQueue taskqueue = new TaskQueue();
                TaskThreadFactory tf = new TaskThreadFactory(this.endpointName + "-exec-", true, this.getThreadPriority());
                TomcatMonitorThreadPoolExecutor executor = new TomcatMonitorThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, (ThreadFactory)tf);
                this.http11NioExecutor = executor;
                taskqueue.setParent((ThreadPoolExecutor)this.http11NioExecutor);
            }
        }

        public void start() throws Exception {
            try {
                this.createExecutor();
                this.setExecutor(this.http11NioExecutor);
            }
            catch (Exception e) {
                logger.warn("getEndpoint \u5931\u8d25\uff0c\u4e0d\u4f1a\u7ed9tomcat\u6ce8\u5165\u7ebf\u7a0b\u6c60\u76d1\u63a7\u529f\u80fd", (Throwable)e);
            }
            super.start();
        }

        public void stop() throws Exception {
            super.stop();
            if (this.http11NioExecutor != null && this.http11NioExecutor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.http11NioExecutor;
                tpe.shutdownNow();
                if (this.executorTerminationTimeoutMillis > 0L) {
                    try {
                        tpe.awaitTermination(this.executorTerminationTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (tpe.isTerminating()) {
                        this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.endpointName}));
                    }
                }
                TaskQueue queue = (TaskQueue)tpe.getQueue();
                queue.setParent(null);
            }
        }
    }
}

