/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import cn.com.duiba.boot.cat.CatWithArgs;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClientFactoryBean;

public class CustomFeignClientFactoryBean
extends FeignClientFactoryBean {
    private String springApplicationName;

    public Object getObject() throws Exception {
        Class classType = super.getObjectType();
        Object feignClient = super.getObject();
        return Proxy.newProxyInstance(classType.getClassLoader(), new Class[]{classType}, (InvocationHandler)new FeignClientInvocationHandler(this.springApplicationName, feignClient, this.getName()));
    }

    public void setSpringApplicationName(String springApplicationName) {
        this.springApplicationName = springApplicationName;
    }

    @VisibleForTesting
    public static class FeignClientInvocationHandler
    implements InvocationHandler {
        private String springApplicationName;
        private String serverName;
        private Object original;

        FeignClientInvocationHandler(String springApplicationName, Object original, String serverName) {
            this.springApplicationName = springApplicationName;
            this.original = original;
            this.serverName = serverName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || method.isDefault()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            RpcContext.getContext().setMethod(method);
            RpcContext.getContext().setInvokeArgs(args);
            if (!CatUtils.isCatEnabled()) {
                return this.invokeMethodInner(method, this.original, args);
            }
            String loggerName = this.resolveLoggerName(method, args);
            Transaction transaction = Cat.newTransaction((String)"PigeonCall", (String)loggerName);
            try {
                RpcCatContext context = new RpcCatContext();
                Cat.logRemoteCallClient((Cat.Context)context);
                this.setAttachment(context, method);
                Object result = this.invokeMethodInner(method, this.original, args);
                transaction.setStatus("0");
                Object object = result;
                return object;
            }
            catch (Throwable e) {
                if (!(e instanceof BizException)) {
                    Cat.logError((Throwable)e);
                    transaction.setStatus(e);
                } else {
                    transaction.setStatus(String.format("BizException(message:%s,code:%s)(this exception will not trigger hystrix)", e.getMessage(), ((BizException)e).getCode()));
                }
                throw e;
            }
            finally {
                this.createConsumerCross(transaction);
                CatUtils.completeTransaction(transaction);
            }
        }

        private String resolveLoggerName(Method method, Object[] args) {
            StringBuilder loggerName = new StringBuilder(method.getDeclaringClass().getSimpleName()).append(".").append(method.getName());
            if (method.isAnnotationPresent(CatWithArgs.class)) {
                CatWithArgs catWithArgs = method.getAnnotation(CatWithArgs.class);
                int[] argIndexes = catWithArgs.argIndexes();
                if (argIndexes == null || argIndexes.length == 0 || args == null || args.length == 0) {
                    return loggerName.toString();
                }
                StringBuilder sb = new StringBuilder();
                for (int argIdx : argIndexes) {
                    if (argIdx < 0 || args.length <= argIdx) continue;
                    Object obj = args[argIdx];
                    sb.append(obj == null ? "" : obj.toString()).append(",");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.insert(0, "(");
                    sb.append(")");
                }
                loggerName.append((CharSequence)sb);
            }
            return loggerName.toString();
        }

        private Object invokeMethodInner(Method method, Object target, Object[] args) throws Throwable {
            try {
                return method.invoke(target, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (e instanceof HystrixBadRequestException && e.getCause() != null && e.getCause() instanceof BizException) {
                    e = e.getCause();
                }
                throw e;
            }
        }

        private void setAttachment(Cat.Context context, Method method) {
            RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
            RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
            RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
            RpcContext.getContext().setAttachment("X-Rpc-Client", this.springApplicationName);
        }

        private void createConsumerCross(Transaction transaction) {
            Event crossAppEvent = Cat.newEvent((String)"PigeonCall.app", (String)(this.springApplicationName + "[" + RpcContext.getContext().getLocalAddr() + "]"));
            Event crossServerEvent = Cat.newEvent((String)"PigeonCall.server", (String)(this.serverName + "[" + RpcContext.getContext().getRemoteAddr() + "]"));
            transaction.addChild((Message)crossAppEvent);
            transaction.addChild((Message)crossServerEvent);
        }

        private void completeEvent(Event event) {
            AbstractMessage message = (AbstractMessage)event;
            message.setCompleted(true);
            message.setStatus("0");
        }

        private static class RpcCatContext
        implements Cat.Context {
            private Map<String, String> properties = new HashMap<String, String>();

            private RpcCatContext() {
            }

            public void addProperty(String key, String value) {
                this.properties.put(key, value);
            }

            public String getProperty(String key) {
                return this.properties.get(key);
            }
        }
    }
}

