/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization.serializers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import shaded.org.nustaq.serialization.FSTBasicObjectSerializer;
import shaded.org.nustaq.serialization.FSTClazzInfo;
import shaded.org.nustaq.serialization.FSTObjectInput;
import shaded.org.nustaq.serialization.FSTObjectOutput;
import shaded.org.nustaq.serialization.util.FSTUtil;

public class FSTEnumSetSerializer
extends FSTBasicObjectSerializer {
    Field elemType;

    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        EnumSet enset = (EnumSet)toWrite;
        int count = 0;
        out.writeInt(enset.size());
        if (enset.isEmpty()) {
            EnumSet compl = EnumSet.complementOf(enset);
            out.writeClassTag(FSTUtil.getRealEnumClass(compl.iterator().next().getClass()));
        } else {
            for (Object element : enset) {
                if (count == 0) {
                    out.writeClassTag(FSTUtil.getRealEnumClass(element.getClass()));
                }
                out.writeObjectInternal(element, null, Enum.class);
                ++count;
            }
        }
    }

    @Override
    public boolean alwaysCopy() {
        return false;
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        int len = in.readInt();
        Class elemCl = FSTUtil.getRealEnumClass(in.readClass().getClazz());
        EnumSet<Object> enSet = EnumSet.noneOf(elemCl);
        in.registerObject(enSet, streamPosition, serializationInfo, referencee);
        for (int i = 0; i < len; ++i) {
            enSet.add(in.readObjectInternal(Enum.class));
        }
        return enSet;
    }
}

