package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;

public class Consumer {
    public static void main(String[] args) throws MQClientException {
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer("testGroup");
        //consumer.setConsumerGroup();
        consumer.setNamesrvAddr("test.config.dui88.com:9876");
        consumer.setConsumeMessageBatchMaxSize(1);//监听器每次接受本地队列的消息是多少条(从服务器获取还是多条的，只是本地MessageListener每次处理只有一条)

        consumer.subscribe("activitySubCreditsCallbackDaily", "*");
        //尽量使用MessageListenerConcurrently来消费，吞吐量更高，消费无顺序
        //当对消息消费顺序有严格要求时，请使用MessageListenerOrderly
        consumer.registerMessageListener(new MessageListenerConcurrently() {
            @Override
            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                System.out.println(msgs.get(0).getKeys());
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        });

        consumer.start();
    }
}
