package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class Producer {
    public static void main(String[] args) throws MQClientException, RemotingException, InterruptedException, MQBrokerException {
        /**
         * 一个应用创建一个Producer，由应用来维护此对象，可以设置为全局对象或者单例<br>
         */
        DefaultMQProducerWrapper p = new DefaultMQProducerWrapper();

        /**
         * producerGroup 这个概念发送普通的消息时，作用不大，但是发送分布式事务消息时，比较关键，
         * 因为服务器会回查这个Group下的任意一个Producer
         * 建议把producerGroup设置成应用名
         */
        p.setProducerGroup("PID-test");
        p.setNamesrvAddr("test.config.dui88.com:9876");
        //p.setInstanceName("Producer");
        p.setSendMsgTimeout(1000);//单位：ms
        /**
         * Producer对象在使用之前必须要调用start初始化，初始化一次即可<br>
         * 注意：切记不可以在每次发送消息时，都调用start方法
         */
        p.start();

        for(int i=0;i<10;i++) {
            Message msg = new Message("test", "12".getBytes());
            msg.setKeys("key"+i);
            SendResult r = p.send(msg);
            System.out.println(r.getMsgId());
        }
    }
}
