/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import sun.net.util.IPAddressUtil;

public class HttpRequestUtils {
    public static boolean isLocalRequest(HttpServletRequest request) {
        boolean isFromLocalIp = RequestTool.isLocalRequest((HttpServletRequest)request);
        if (!isFromLocalIp) {
            return false;
        }
        boolean isUrlFromLocal = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            if (url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1")) {
                isUrlFromLocal = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLocal;
    }

    public static boolean isLanRequest(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("x-forwarded-for"))) {
            return false;
        }
        String ip = RequestTool.getIpAddr((HttpServletRequest)request);
        boolean isLanIp = false;
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || HttpRequestUtils.isLanIp(ip)) {
            isLanIp = true;
        }
        if (!isLanIp) {
            return false;
        }
        boolean isUrlFromLan = false;
        try {
            URL url = new URL(request.getRequestURL().toString());
            String urlHost = url.getHost();
            if (urlHost.equals("127.0.0.1") || urlHost.equals("localhost") || HttpRequestUtils.isLanIp(urlHost)) {
                isUrlFromLan = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isUrlFromLan;
    }

    protected static boolean isLanIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return HttpRequestUtils.isLanIp(addr);
    }

    private static boolean isLanIp(byte[] addr) {
        if (addr == null || addr.length < 2) {
            return false;
        }
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

