package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransaction;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;

/**
 * RocketMQ MessageListener的包装，增加cat监控
 */
public class MessageListenerConcurrentlyWrapper implements MessageListenerConcurrently {

    private MessageListenerConcurrently source;

    public MessageListenerConcurrentlyWrapper(MessageListenerConcurrently source){
        this.source = source;
    }

    @Override
    @CatTransaction(type="MessageQueue", name="RocketMQ.consume")
    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        DBTimeProfile.start();
        try {
            return source.consumeMessage(msgs, context);
        }finally {
            DBTimeProfile.end("RocketMQ.consume");
        }
    }
}
