package cn.com.duibaboot.ext.autoconfigure.web.mvc;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

import java.io.IOException;
import java.lang.reflect.Type;

/**
 * spring mvc 的httpMessageConverter，用于在Object和Fst/kryo/hessian2等字节流之间转换
 */
public class BaseBytesToObjectMessageConverter extends AbstractGenericHttpMessageConverter<Object> {

    private DuibaFeignProperties.DuibaFeignSerialization serialization;

    public BaseBytesToObjectMessageConverter(DuibaFeignProperties.DuibaFeignSerialization serialization){
        super(MediaType.valueOf(getWildContentType(serialization.getContentType())));
        this.serialization = serialization;
    }

    /**
     * 把contentType的第二部分转为*(这里一定要带上*后缀，不然可能会比jsonMessageConverter优先级高)
     *
     * 比如 fst-bytes/fst 转为 fst-bytes/*
     *
     * @param contentType
     * @return
     */
    private static String getWildContentType(String contentType){
        return contentType.substring(0, contentType.indexOf("/")) + "/*";
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return read(null, clazz, inputMessage);
    }

    @Override
    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        byte[] body = IOUtils.toByteArray(inputMessage.getBody());

        return serialization.deserialize(body);
    }

    @Override
    protected void writeInternal(Object o, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        byte[] bs = serialization.serialize(o);
        outputMessage.getBody().write(bs);
    }
}
