package cn.com.duibaboot.ext.autoconfigure.web.container;


import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;
import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * 改变undertow的org.xnio.XnioWorker$TaskPool内部类的字节码，使得提交的runnable封装成MonitorRunnable后再提交
 */
public class UndertowInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "org.xnio.XnioWorker$TaskPool";//$TaskPool
    private static final String METHOD_INTERCET_CLASS = UndertowMethodInterceptor.class.getName();

    @Override
    public ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }


    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
            new InstanceMethodsInterceptPoint() {
                @Override
                public ElementMatcher<MethodDescription> getMethodsMatcher() {
                    return named("execute");
                }

                @Override
                public String getMethodsInterceptor() {
                    return METHOD_INTERCET_CLASS;
                }

                @Override public boolean isOverrideArgs() {
                    return true;
                }
            }
        };
    }
}
