package cn.com.duibaboot.ext.autoconfigure.web.cookie;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 自动加入Http Filter，修复tomcat 8.5.* 版本对RFC2109的cookie识别出来两边会带上引号的问题。
 * 修复tomcat 8.5.*版本对RFC2109的cookie处理的问题。RFC2109的cookie比如：
 * $Version="1"; _ac="eyJhaWQiOjE5NTI0LCJjaWQiOjUzMzUyMjk2OX0=";$Path="/";$Domain="duiba.com.cn"
 * <br/>
 * tomcat8.5.*版本在处理的时候会把_ac中的左右两个双引号也作为value的一部分，导致程序获取失败；tomcat8.0.*版本没有此问题。
 * 附上rfc2109的文档：https://tools.ietf.org/html/rfc2109#section-4.3.4
 */
public class Rfc2109CookieFixFilter implements Filter {

	@Override
	public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
		chain.doFilter(new Rfc2109CookieFixHttpServletRequestWrapper((HttpServletRequest) req), resp);
	}

	@Override
	public void destroy() {
	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
	}

}
