/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.accesslog;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnClass(value={LoggerContext.class})
@ConditionalOnResource(resources={"/logback/access-logback.xml"})
@ConditionalOnWebApplication
public class AccessLogAutoConfiguration {
    private static Logger LOG = LoggerFactory.getLogger(AccessLogAutoConfiguration.class);

    @Bean
    public ApplicationListener accesslogLogbackConfig() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    try {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)loggerContext);
                        configurator.doConfigure(new ClassPathResource("/logback/access-logback.xml").getInputStream());
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    this.flag = false;
                }
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={LoggerContext.class})
    @ConditionalOnResource(resources={"/logback/access-logback.xml"})
    @ConditionalOnWebApplication
    public static class AccessLogHttpFilterConfiguration {
        @Bean
        public FilterRegistrationBean acesslogHttpFilterConfigurer() {
            AccessLogFilter filter2 = new AccessLogFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter2);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(100);
            try {
                Properties p = new Properties();
                p.load(new ClassPathResource("/accesslog_filter.properties").getInputStream());
                if (!p.isEmpty()) {
                    filter2.loadConfig(p);
                    LOG.info("load accesslog_filter.properties success");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return registrationBean;
        }
    }
}

