/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomSpringMvcContract;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix.HystrixFeignConfiguration;
import com.netflix.hystrix.HystrixCommand;
import feign.Contract;
import feign.RequestInterceptor;
import feign.hystrix.HystrixFeign;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.feign.AnnotatedParameterProcessor;
import org.springframework.cloud.netflix.feign.FeignFormatterRegistrar;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;

@Configuration
@ConditionalOnClass(value={HystrixCommand.class, HystrixFeign.class})
@Import(value={HystrixFeignConfiguration.class})
@EnableConfigurationProperties(value={DuibaFeignProperties.class})
public class FeignAutoConfiguration {
    @Resource
    private DuibaFeignProperties duibaFeignProperties;
    @Autowired(required=false)
    private List<AnnotatedParameterProcessor> parameterProcessors = new ArrayList<AnnotatedParameterProcessor>();
    @Autowired(required=false)
    private List<FeignFormatterRegistrar> feignFormatterRegistrars = new ArrayList<FeignFormatterRegistrar>();

    @Bean
    public Contract feignContract(ConversionService customFeignConversionService) {
        return new CustomSpringMvcContract(this.parameterProcessors, customFeignConversionService, this.duibaFeignProperties);
    }

    @Bean
    public FormattingConversionService customFeignConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        for (FeignFormatterRegistrar feignFormatterRegistrar : this.feignFormatterRegistrars) {
            feignFormatterRegistrar.registerFormatters((FormatterRegistry)conversionService);
        }
        return conversionService;
    }

    @Bean
    public RequestInterceptor getCustomRequestInterceptor() {
        return new CustomRequestInterceptor(this.duibaFeignProperties);
    }
}

