package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.sleuth.Span;
import org.springframework.context.annotation.*;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;

/**
 * Created by wenqi.huang on 2016/11/7.
 */
@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
public class SleuthAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SleuthAutoConfiguration.class);

//    @Configuration
//    @ConditionalOnClass({Servlet.class, Span.class, InterceptorRegistry.class})
//    @ConditionalOnWebApplication
//    @Order(-99)
//    public static class SleuthHttpHandlerInterceptorConfiguration extends WebMvcConfigurerAdapter {
//
//        @Override
//        public void addInterceptors(InterceptorRegistry registry) {
//            CatHandlerInterceptor chi = new CatHandlerInterceptor() {
//
//                @Override
//                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
//                    if ("true".equals(request.getHeader(CustomRequestInterceptor.X_RPC))) {
//                        //不处理RPC请求（来自FeignClient的rest rpc调用）
//                        return true;
//                    }
//
//                    //如果不是前端资源，则继续cat的处理流程
//                    return super.preHandle(request, response, handler);
//                }
//
//            };
//            registry.addInterceptor(chi);
//            super.addInterceptors(registry);
//        }
//
//    }

    @Configuration
    @ConditionalOnClass({SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, Span.class})
    public static class SleuthMyBatisPostProcessorConfiguration{

        @Bean
        public SleuthMybatisPlugin sleuthMybatisPlugin(){
            return new SleuthMybatisPlugin();
        }

        /**
         * 声明后置处理器，spring全部bean初始化完成后调用，给所有SqlSessionBean注入SleuthMybatisPlugin plugin，监控sql的执行
         * @return
         */
        @Bean
        public SpecifiedBeanPostProcessor sleuthMyBatisPostProcessorConfigurer(){
            return new SpecifiedBeanPostProcessor<Object>() {
                @Override
                public int getOrder() {
                    return -1;
                }

                @Override
                public Class<Object> getBeanType() {
                    return Object.class;
                }

                @Override
                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                	SqlSessionFactory s = null;
                    if(bean instanceof SqlSessionFactory){
                        s = (SqlSessionFactory)bean;
                    }
                    if(bean instanceof SqlSessionTemplate){
                        s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
                    }
                    if(s == null){
                        return bean;
                    }

                    boolean hasCatPlugin = false;
                    if(s.getConfiguration().getInterceptors() != null && !s.getConfiguration().getInterceptors().isEmpty()) {
                        for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                            if (plugin instanceof SleuthMybatisPlugin) {
                                hasCatPlugin = true;
                                break;
                            }
                        }
                    }else{
                    }

                    if (!hasCatPlugin) {
                        s.getConfiguration().addInterceptor(sleuthMybatisPlugin());
                    }

                    return bean;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass({RedisClient.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthRedisPluginConfiguration{

    	@Bean
    	public SleuthRedisPlugin sleuthRedisPlugin(){
    		return new SleuthRedisPlugin();
    	}

    }

    /**
     * 加入aop，监控spring-data-redis执行耗时
     */
    @Configuration
    @ConditionalOnClass({JedisConnectionFactory.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthSpringDataRedisAspectConfiguration{

    	@Bean
    	public SleuthSpringDataRedisPlugin sleuthSpringDataRedisAspectPlugin(){
    		return new SleuthSpringDataRedisPlugin();
    	}

    }

//    @Configuration
//    @ConditionalOnClass({XMemcacheClient.class, MemcachedClient.class, Span.class, Aspect.class})
//    public static class SleuthMemcacheConfiguration{
//
//    	@Bean
//    	public SleuthMemcachePlugin sleuthMemcachePlugin(){
//    		return new SleuthMemcachePlugin();
//    	}
//
//    }

//    @Configuration
//    @ConditionalOnClass({MongoOperations.class, Span.class, Aspect.class})
//    public static class SleuthMongodbConfiguration{
//
//    	@Bean
//    	public SleuthSpringDataMongodbPlugin sleuthSpringDataMongodbPlugin(){
//    		return new SleuthSpringDataMongodbPlugin();
//    	}
//
//    }
//
//    @Configuration
//    @ConditionalOnClass({ElasticsearchOperations.class, Span.class, Aspect.class})
//    public static class SleuthElasticsearchConfiguration{
//
//    	@Bean
//    	public SleuthSpringDataElasticSearchPlugin sleuthSpringDataElasticSearchPlugin(){
//    		return new SleuthSpringDataElasticSearchPlugin();
//    	}
//
//    }

//    @Configuration
//    @ConditionalOnClass({HbaseTemplate.class, HTable.class, Span.class, Aspect.class})
//    public static class SleuthHbaseConfiguration{
//
//        @Bean
//        public SleuthSpringDataHbaseAspect sleuthSpringDataHbaseAspect(){
//            return new SleuthSpringDataHbaseAspect();
//        }
//
//    }

//    /**
//     * 监控dubbo线程池使用情况，给cat发送心跳来记录
//     */
//    @Configuration
//    @ConditionalOnClass({DubboRegistry.class, DataStore.class, CatFilter.class})
//    public static class DubboThreadPoolWaterLevelHeartbeatExtenstion implements StatusExtension, Initializable {
//
//        //给当前的类定义一个extension id, cat服务端会将一个extension id作为一个group，然后将每个key指标都会做图形处理，结果会在cat的heartbeat中进行展示
//        @Override
//        public String getId() {
//            return ThreadPoolWaterLevelId;
//        }
//
//        //一个简单描述
//        @Override
//        public String getDescription() {
//            return "各个线程池的水位监控心跳";
//        }
//
//        //每隔一分钟自动被cat调用一次
//        @Override
//        public Map<String, String> getProperties() {
//            Map<String, String> maps = new HashMap<>();
//
//            DataStore dataStore = ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
//            Map<String, Object> executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
//
//            for(Map.Entry<String, Object> entry : executors.entrySet()) {
//                String port = entry.getKey();
//                ExecutorService executor = (ExecutorService) entry.getValue();
//
//                if (executor != null && executor instanceof ThreadPoolExecutor) {
//                    ThreadPoolExecutor tp = (ThreadPoolExecutor) executor;
//
//                    //这里的每个key指标都会做图形处理，结果会在cat的heartbeat中进行展示,注意，只有value值可以被转化double类型的才会在heartbeat做图形展示
//                    String portStr = executors.size() == 1 ? "" : ("port:" + port) + ",";
//                    maps.put("Dubbo-ActiveCount("+portStr+"core:"+tp.getCorePoolSize()+",max:"+tp.getMaximumPoolSize()+")", String.valueOf(tp.getActiveCount()));
//                }
//            }
//
//            return maps;
//        }
//
//        //这里是实现了初始化方法，把这个实现注册到cat上，如果你使用spring，需要在spring里面注册此bean，并实现初始化方法。
//        @Override
//        @PostConstruct
//        public void initialize() throws InitializationException {
//            StatusExtensionRegister.getInstance().register(this);
//        }
//
//    }
//
//    /**
//     * 监控Tomcat http线程池使用情况，给cat发送心跳来记录
//     */
//    @Configuration
//    @ConditionalOnWebApplication
//    @ConditionalOnClass({TomcatEmbeddedServletContainerFactory.class, Tomcat.class, Servlet.class, CatFilter.class})
//    public static class HttpThreadPoolWaterLevelHeartbeatExtenstion implements StatusExtension, Initializable, ApplicationListener<EmbeddedServletContainerInitializedEvent> {
//
//        private ThreadPoolExecutor httpThreadPool;
//
//        //给当前的类定义一个extension id, cat服务端会将一个extension id作为一个group，然后将每个key指标都会做图形处理，结果会在cat的heartbeat中进行展示
//        @Override
//        public String getId() {
//            return ThreadPoolWaterLevelId;
//        }
//
//        //一个简单描述
//        @Override
//        public String getDescription() {
//            return "各个线程池的水位监控心跳";
//        }
//
//        //每隔一分钟自动被cat调用一次
//        @Override
//        public Map<String, String> getProperties() {
//            Map<String, String> maps = new HashMap<>();
//
//            if(httpThreadPool != null) {
//                maps.put("Http-ActiveCount(core:" + httpThreadPool.getCorePoolSize() + ",max:" + httpThreadPool.getMaximumPoolSize() + ")", String.valueOf(httpThreadPool.getActiveCount()));
//            }
//
//            return maps;
//        }
//
//        //这里是实现了初始化方法，把这个实现注册到cat上，如果你使用spring，需要在spring里面注册此bean，并实现初始化方法。
//        @Override
//        @PostConstruct
//        public void initialize() throws InitializationException {
//        }
//
//        @Override
//        public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
//            EmbeddedServletContainer c = event.getEmbeddedServletContainer();
//
//            if(!(c instanceof TomcatEmbeddedServletContainer)){
//                return;
//            }
//            TomcatEmbeddedServletContainer container = (TomcatEmbeddedServletContainer)c;
//
//            Executor es = container.getTomcat().getConnector().getProtocolHandler().getExecutor();
//            if(!(es instanceof ThreadPoolExecutor)) {
//                return;
//            }
//            httpThreadPool = (ThreadPoolExecutor)es;
//            //基本的校验通过才注册到cat回调
//            StatusExtensionRegister.getInstance().register(this);
//        }
//    }
//
//    /**
//     * 监控DuibaBiz线程池使用情况，给cat发送心跳来记录
//     */
//    @Configuration
//    @ConditionalOnClass({CatFilter.class})
//    public static class DubiaBizThreadPoolWaterLevelHeartbeatExtenstion implements StatusExtension, Initializable, ApplicationListener<ContextRefreshedEvent> {
//
//        private ThreadPoolExecutorWrapper executorService;
//        private ScheduledThreadPoolExecutorWrapper scheduledExecutorService;
//
//        //给当前的类定义一个extension id, cat服务端会将一个extension id作为一个group，然后将每个key指标都会做图形处理，结果会在cat的heartbeat中进行展示
//        @Override
//        public String getId() {
//            return ThreadPoolWaterLevelId;
//        }
//
//        //一个简单描述
//        @Override
//        public String getDescription() {
//            return "各个线程池的水位监控心跳";
//        }
//
//        //每隔一分钟自动被cat调用一次
//        @Override
//        public Map<String, String> getProperties() {
//            Map<String, String> maps = new HashMap<>();
//            if(executorService != null){
//                maps.put("DuibaBiz-ActiveCount(core:"+executorService.getCorePoolSize()+",max:"+executorService.getMaximumPoolSize()+")", String.valueOf(executorService.getActiveCount()));
//            }
//            if(scheduledExecutorService != null){
//                maps.put("DuibaBizScheduled-ActiveCount(core:"+scheduledExecutorService.getCorePoolSize()+",max:"+scheduledExecutorService.getMaximumPoolSize()+")", String.valueOf(scheduledExecutorService.getActiveCount()));
//            }
//
//            return maps;
//        }
//
//        //这里是实现了初始化方法，把这个实现注册到cat上，如果你使用spring，需要在spring里面注册此bean，并实现初始化方法。
//        @Override
//        @PostConstruct
//        public void initialize() throws InitializationException {
//        }
//
//        @Override
//        public void onApplicationEvent(ContextRefreshedEvent event) {
//            ApplicationContext applicationContext = event.getApplicationContext();
//
//            try {
//                Object executorService = applicationContext.getBean("executorService");
//                if(executorService != null && executorService instanceof ThreadPoolExecutorWrapper){
//                    this.executorService = (ThreadPoolExecutorWrapper)executorService;
//                }
//            }catch(Exception e){
//                //Ignore
//            }
//            try{
//                Object scheduledExecutorService = applicationContext.getBean("scheduledExecutorService");
//                if(scheduledExecutorService != null && scheduledExecutorService instanceof ScheduledThreadPoolExecutorWrapper){
//                    this.scheduledExecutorService = (ScheduledThreadPoolExecutorWrapper)scheduledExecutorService;
//                }
//            }catch(Exception e){
//                //Ignore
//            }
//
//            if(this.executorService != null || this.scheduledExecutorService != null){
//                StatusExtensionRegister.getInstance().register(this);
//            }
//        }
//    }

}
