package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

/**
 * eurekaClient实例在 @ConditionalOnRefreshScope 情况下每次 refresh，会销毁重新创建。实例会取消注册，再重新注册到eureka。导致其他应用从eureka获取该应用实例的时候存在找不到的情况
 * 此处扩展后，refresh不再会重新创建eurekaClient实例
 * Created by gyf .
 * 2018/4/27 .
 */
public class EurekaClientBeanDefinitionRegistryPostProcessor implements BeanDefinitionRegistryPostProcessor {

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        BeanDefinition eurekaClientBeanDefinition = registry.getBeanDefinition("eurekaClient");
        if (eurekaClientBeanDefinition == null) {
            return;
        }
        eurekaClientBeanDefinition.setScope(BeanDefinition.SCOPE_SINGLETON);

        BeanDefinition eurekaClientOriginatingBeanDefinition = eurekaClientBeanDefinition.getOriginatingBeanDefinition();
        if (eurekaClientOriginatingBeanDefinition == null) {
            return;
        }
        eurekaClientOriginatingBeanDefinition.setScope(BeanDefinition.SCOPE_SINGLETON);
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {

    }
}
