/*
 * Copyright 2013-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.duibaboot.ext.autoconfigure.etcd;

import java.net.URI;

import mousio.etcd4j.EtcdClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author Spencer Gibb
 */
@Configuration
@EnableConfigurationProperties(EtcdProperties.class)
@ConditionalOnClass(EtcdClient.class)
public class EtcdAutoConfiguration {

    @Autowired
    protected EtcdProperties etcdProperties;

    @Bean
    public EtcdClient etcdClient() {
        return new EtcdClient(etcdProperties.getUris().toArray(new URI[]{}));
    }

    @ConditionalOnClass(AbstractEndpoint.class)
    @ConditionalOnBean(EtcdClient.class)
    @Configuration
    public static class EtcdEndpointConfiguration{

        @Bean
        public EtcdEndpoint etcdEndpoint(EtcdClient etcdClient) {
            return new EtcdEndpoint(etcdClient);
        }

    }

//    @Bean
//    public EtcdHealthIndicator etcdHealthIndicator(EtcdClient client) {
//        return new EtcdHealthIndicator(client);
//    }
}
