/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.ClientAbortExceptionIgnoreFilter;
import cn.com.duibaboot.ext.autoconfigure.web.DBTimeProfileFilter;
import cn.com.duibaboot.ext.autoconfigure.web.cookie.Rfc2109CookieFixFilter;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.BizExceptionResolver;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomHttpMessageConverters;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomWebMvcRegistrations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;

@Configuration
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnWebApplication
public class WebMvcFixAutoConfiguration {
    @Resource
    private List<FilterRegistrationBean> filters;

    @PostConstruct
    public void init() {
        for (FilterRegistrationBean filter2 : this.filters) {
            if (filter2.getOrder() != Integer.MIN_VALUE) continue;
            throw new IllegalStateException("filter:[" + filter2.getFilter().getClass().getName() + "] 's order is too small, must bigger than Integer.MIN_VALUE(the order of OrderedCharacterEncodingFilter), if not, there will be chinese garbled");
        }
    }

    @Bean(name={"viewResolver"})
    @ConditionalOnMissingBean(name={"viewResolver"}, value={ContentNegotiatingViewResolver.class})
    public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
        ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
        resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
        resolver.setOrder(Integer.MAX_VALUE);
        return resolver;
    }

    @Bean
    public BizExceptionResolver bizExceptionResolver() {
        return new BizExceptionResolver();
    }

    @Bean
    public CustomWebMvcRegistrations customWebMvcRegistrations() {
        return new CustomWebMvcRegistrations();
    }

    @Bean
    public SpecifiedBeanPostProcessor httpMessageConvertersPostProcessor() {
        return new SpecifiedBeanPostProcessor<HttpMessageConverters>(){

            public int getOrder() {
                return 0;
            }

            @Override
            public Class<HttpMessageConverters> getBeanType() {
                return HttpMessageConverters.class;
            }

            @Override
            public Object postProcessBeforeInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(HttpMessageConverters bean, String beanName) throws BeansException {
                List converters = bean.getConverters();
                return new CustomHttpMessageConverters(false, converters == null ? Collections.emptyList() : converters);
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class, Request.class})
    @ConditionalOnWebApplication
    public static class Rfc2019CookieFilterConfiguration {
        @Bean
        public FilterRegistrationBean rfc2019CookieFilterConfigurer() {
            Rfc2109CookieFixFilter filter2 = new Rfc2109CookieFixFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter2);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483638);
            return registrationBean;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class, ClientAbortException.class})
    @ConditionalOnWebApplication
    public static class ClientAbortExceptionIgnoreFilterConfiguration {
        @Bean
        public FilterRegistrationBean clientAbortExceptionIgnoreFilterConfigurer() {
            ClientAbortExceptionIgnoreFilter filter2 = new ClientAbortExceptionIgnoreFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter2);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(2);
            return registrationBean;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
    @ConditionalOnWebApplication
    public static class dbTimeProfileFilterConfiguration {
        @Bean
        public FilterRegistrationBean dbTimeProfileFilterConfigurer() {
            DBTimeProfileFilter filter2 = new DBTimeProfileFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter2);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-1);
            return registrationBean;
        }
    }
}

