/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class CatMybatisPlugin
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object returnObj;
        if (!CatInstance.isEnable()) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String[] strArr = mappedStatement.getId().split("\\.");
        String class_method = strArr[strArr.length - 2] + "." + strArr[strArr.length - 1];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        String method = sqlCommandType.name().toLowerCase();
        Transaction t = Cat.newTransaction((String)"SQL", (String)class_method);
        Cat.logEvent((String)"SQL.Method", (String)method);
        CatUtils.TransactionExt transactionExt = new CatUtils.TransactionExt();
        transactionExt.setTransactionName(class_method);
        CatUtils.setCurrentTransaction(transactionExt);
        try {
            returnObj = invocation.proceed();
            if (transactionExt.getTransaction() != null) {
                transactionExt.getTransaction().setStatus("0");
            }
            t.setStatus("0");
        }
        catch (Exception e) {
            String errorMsg = e.getClass().getSimpleName();
            if (transactionExt.getTransaction() != null) {
                transactionExt.getTransaction().setStatus(errorMsg);
            }
            t.setStatus(errorMsg);
            Cat.logError((Throwable)e);
            throw e;
        }
        finally {
            if (transactionExt.getTransaction() != null) {
                transactionExt.getTransaction().complete();
            }
            CatUtils.clearCurrentTransaction();
            t.complete();
        }
        return returnObj;
    }

    public String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", this.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", this.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    private String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }
}

