/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import cn.com.duibaboot.ext.autoconfigure.cloud.zipkin.ZipkinRequest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;

@Order(value=-2147483644)
public class DuibaTraceFilter
implements Filter {
    protected static final String ZIPKIN_MODEL = "runMode";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String model = request.getParameter(ZIPKIN_MODEL);
        String header = request.getHeader("X-B3-Flags");
        Boolean isDebugRunMode = StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)"DEBUG") || "1".equals(header);
        ZipkinRequest zipkinRequest = new ZipkinRequest(request);
        zipkinRequest.setDebugMode(isDebugRunMode);
        if (isDebugRunMode.booleanValue()) {
            zipkinRequest.setAttribute("X-B3-Flags", "1");
        } else {
            zipkinRequest.setAttribute("X-B3-Flags", "0");
        }
        filterChain.doFilter((ServletRequest)zipkinRequest, servletResponse);
    }

    public void destroy() {
    }
}

