/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.config;

import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdConfigProperties;
import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdPropertySourceLocator;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.stream.Collectors;
import mousio.etcd4j.EtcdClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EtcdConfigApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static Log logger = LogFactory.getLog(EtcdConfigApplicationContextInitializer.class);
    private int order = -2147483636;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableEnvironment configurableEnvironment = configurableApplicationContext.getEnvironment();
        String uri = configurableEnvironment.getProperty("duiba.cloud.etcd.uris");
        if (!Strings.isNullOrEmpty((String)uri)) {
            try {
                EtcdConfigProperties etcdConfigProperties = new EtcdConfigProperties();
                URI[] list = Splitter.on((String)",").splitToList((CharSequence)uri).stream().map(URI::create).collect(Collectors.toList()).toArray(new URI[0]);
                EtcdClient etcdClient = new EtcdClient(list);
                EtcdPropertySourceLocator etcdPropertySourceLocator = new EtcdPropertySourceLocator(etcdClient, etcdConfigProperties);
                PropertySource<?> propertySource = etcdPropertySourceLocator.locate((Environment)configurableEnvironment);
                configurableEnvironment.getPropertySources().addFirst(propertySource);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

