/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.mvc;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class BaseBytesToObjectMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    private DuibaFeignProperties.DuibaFeignSerialization serialization;

    public BaseBytesToObjectMessageConverter(DuibaFeignProperties.DuibaFeignSerialization serialization) {
        super(MediaType.valueOf((String)BaseBytesToObjectMessageConverter.getWildContentType(serialization.getContentType())));
        this.serialization = serialization;
    }

    private static String getWildContentType(String contentType) {
        return contentType.substring(0, contentType.indexOf("/")) + "/*";
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.read(null, clazz, inputMessage);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        byte[] body = IOUtils.toByteArray((InputStream)inputMessage.getBody());
        return this.serialization.deserialize(body);
    }

    protected void writeInternal(Object o, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        byte[] bs = this.serialization.serialize(o);
        outputMessage.getBody().write(bs);
    }
}

