package cn.com.duibaboot.ext.autoconfigure.core.utils;

import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.*;

public class FileUtils {

    /**
     * 重命名文件，如果对应的新文件名存在，直接覆盖掉
     * @param file 要修改的文件
     * @param newName 新名称
     */
    public static void rename(File file,String newName){
        if(!file.exists()){
            return;
        }
        if(StringUtils.equals(file.getName(),newName)){
            return;
        }

        String path = file.getParent();
        String newfileName = path+"/"+newName;
        File dest = new File(newfileName);
        if (dest.exists()) {
            dest.delete();
        }
        file.renameTo(dest);
    }

    /**
     * 获取文件名称 不包含后缀
     * @param file 文件
     * @return 文件名称
     */
    public static String getFileName(File file){
        if(!file.exists()){
            return "";
        }
        String fileName = file.getName();
        int index = fileName.lastIndexOf(".");
        if(index==-1){
            return fileName;
        }
        return fileName.substring(0,fileName.lastIndexOf("."));
    }

    /**
     * 获取文件后缀
     * @param file 文件
     * @return 后缀，包含 .
     */
    public static String getFileSuffix(File file){
        if(!file.exists()){
            return "";
        }
        String fileName = file.getName();
        int index = fileName.lastIndexOf(".");
        if(index==-1){
            return "";
        }
        return fileName.substring(index,fileName.length());
    }


    /**
     * 从根目录开始查找出所有的文件
     * @param rootPath 根目录
     * @return 文件集合
     */
    public static List<File> findAllFileByRootPath(File rootPath){
        if(!rootPath.exists()){
            return Collections.emptyList();
        }
        if(!rootPath.isDirectory()){
            return Lists.newArrayList(rootPath);
        }

        List<File> returnList = Lists.newArrayList();

        LinkedList<File> list = Lists.newLinkedList();
        File[] files = rootPath.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            if (file.isDirectory()) {
                list.add(file);
            } else {
                returnList.add(file);
            }
        }
        File tempFile;
        while (!list.isEmpty()) {
            tempFile = list.removeFirst();
            files = tempFile.listFiles();
            for (File file : Objects.requireNonNull(files)) {
                if (file.isDirectory()) {
                    list.add(file);
                } else {
                    returnList.add(file);
                }
            }
        }
        return returnList;
    }

    /**
     * 获取当前应用的日志根目录
     * @return 目录Path
     */
    public static String getLogRootPath(){
        Reader reader = null;
        try{
            URL bootstrap = Thread.currentThread().getContextClassLoader ().getResource("bootstrap.properties");

            if(bootstrap==null){
                throw new RuntimeException("classPath://bootstrap.properties缺失");
            }
            CharSource charSource = Resources.asCharSource(bootstrap, Charset.forName("utf-8"));
            reader = charSource.openStream();
            Properties properties = new Properties();
            properties.load(reader);

            String appName = properties.getProperty("spring.application.name");
            String usrHome = System.getProperty("user.home");
            return usrHome+ "/logs/" +appName;
        }catch (Exception e){
            throw new RuntimeException(e);
        }finally {
            IOUtils.closeQuietly(reader);
        }
    }

}
