package cn.com.duibaboot.ext.autoconfigure.datasource;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * 启动早期阶段注入BeanDefinitionRegistryPostProcessor（没有使用@Bean是因为自动配置太晚，JdbcTemplateAutoConfiguration的ConditionalOnSingleCandidate不会生效）
 */
public class DuibaDataSourceRegistryContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        DataSourceBeanDefinitionRegistryPostProcessor processor = new DataSourceBeanDefinitionRegistryPostProcessor();
        processor.setEnvironment(applicationContext.getEnvironment());
        applicationContext.addBeanFactoryPostProcessor(processor);
    }
}
