package cn.com.duibaboot.ext.autoconfigure.dbexec;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorMediaTypes;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 执行命令的端点
 * Created by guoyanfei .
 * 2018/5/28 .
 */
public class ExecMvcEndpoint extends AbstractNamedMvcEndpoint {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExecMvcEndpoint.class);

    //sse超时时间10s
    private static final long SSE_TIMEOUT = 20000L;

    private static final ExecutorService es =  new ThreadPoolExecutor(5, 5,
                                                                      0L, TimeUnit.MILLISECONDS,
                                                                      new SynchronousQueue<Runnable>());

    public ExecMvcEndpoint() {
        super("dbexec", "/dbexec", true);
    }

    @RequestMapping(
            method = RequestMethod.GET,
            produces = {
                    ActuatorMediaTypes.APPLICATION_ACTUATOR_V1_JSON_VALUE,
                    MediaType.APPLICATION_JSON_VALUE
            },
            value = "/{commandKey}"
    )
    public SseEmitter invoke(@PathVariable String commandKey) {
        if (StringUtils.isBlank(commandKey)) {
            throw new RuntimeException("commandKey 不能为 null");
        }
        if (!ExecutableCommand.contains(commandKey)) {
            throw new RuntimeException("非法的 commandKey");
        }
        return buildSseEmitter(ExecutableCommand.get(commandKey));
    }

    private void execute(SseEmitter sseEmitter, String command) {
        es.execute(new Runnable() {

            private void process() {
                Process process = null;
                InputStreamReader inputStreamReader = null;
                LineNumberReader lineNumberReader = null;
                try {
                    process = Runtime.getRuntime().exec(command);
                    inputStreamReader = new InputStreamReader(process.getInputStream());
                    lineNumberReader = new LineNumberReader(inputStreamReader);

                    String line;
                    while ((line = lineNumberReader.readLine()) != null) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("execReuslt", line);

                        sseEmitter.send(jsonObject.toString(), MediaType.APPLICATION_JSON_UTF8);
                    }
                } catch (Exception e) {
                    LOGGER.error("", e);
                    sseEmitter.completeWithError(e);
                } finally {
                    if (process != null) {
                        process.destroy();
                    }
                    if (inputStreamReader != null) {
                        try { inputStreamReader.close(); } catch (IOException ignored) {}
                    }
                    if (lineNumberReader != null) {
                        try { lineNumberReader.close(); } catch (IOException ignored) {}
                    }
                    sseEmitter.complete();
                }
            }

            @Override
            public void run() {
                process();
            }
        });
    }

    private SseEmitter buildSseEmitter(ExecutableCommand executableCommand) {
        SseEmitter sseEmitter = new SseEmitter(SSE_TIMEOUT);
        String command = this.renderCommand(executableCommand);
        try {
            this.execute(sseEmitter, command);
        } catch (Exception e) {
            LOGGER.error("", e);
            sseEmitter.completeWithError(e);
        }
        return sseEmitter;
    }

    /**
     * 命令中的填充插值
     * @param commandEnum
     * @return
     */
    private String renderCommand(ExecutableCommand commandEnum) {
        String command = commandEnum.getCommand();
        command = command.replace("${vmid}", JvmIdTool.getVmId());
        return command;
    }

}
