package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * eurekaClient实例在 @ConditionalOnRefreshScope 情况下每次 refresh，会销毁重新创建。实例会取消注册，再重新注册到eureka。导致其他应用从eureka获取该应用实例的时候存在找不到的情况
 * 此处扩展后，refresh不再会重新创建eurekaClient实例
 * Created by gyf .
 * 2018/4/27 .
 */
@Configuration
public class EurekaClientPostProcessorAutoConfiguration {

    //BeanDefinitionRegistryPostProcessor的声明必须是static的
    @Bean
    public static EurekaClientBeanDefinitionRegistryPostProcessor eurekaClientBeanDefinitionRegistryPostProcessor() {
        return new EurekaClientBeanDefinitionRegistryPostProcessor();
    }

    /**
     * aop强制延迟注册eureka，延迟到web端口绑定后再注册到eureka。
     * <br/>
     * 确保在web容器启动完成前，eureka状态不会改为UP, 以避免kong检测到UP状态的服务器直接放行流量导致访问不通的问题。
     *
     * @return
     */
    @Bean
    public static EurekaAutoServiceRegistrationPostProcessor eurekaAutoServiceRegistrationPostProcessor() {
        return new EurekaAutoServiceRegistrationPostProcessor();
    }

}
