package cn.com.duibaboot.ext.autoconfigure.config;

import cn.com.duibaboot.ext.autoconfigure.etcd.config.EtcdConfigProperties;
import cn.com.duibaboot.ext.autoconfigure.etcd.config.EtcdPropertySourceLocator;
import com.coreos.jetcd.Client;
import com.google.common.base.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

/**
 * etcd配置加载
 * Created by gyf .
 * 2018/4/3 .
 */
public class EtcdConfigApplicationContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    private static Log logger = LogFactory.getLog(EtcdConfigApplicationContextInitializer.class);

    private int order = Ordered.HIGHEST_PRECEDENCE + 12;

    private static volatile Client client;

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableEnvironment configurableEnvironment = configurableApplicationContext.getEnvironment();
        String uri = configurableEnvironment.getProperty("duiba.cloud.etcd.uris");
        if (!Strings.isNullOrEmpty(uri)) {
            try {
                EtcdConfigProperties etcdConfigProperties = new EtcdConfigProperties();
                if (client == null) {
                    client = Client.builder().endpoints(uri.split(",")).build();
                }
                EtcdPropertySourceLocator etcdPropertySourceLocator = new EtcdPropertySourceLocator(client, etcdConfigProperties);
                PropertySource propertySource = etcdPropertySourceLocator.locate(configurableEnvironment);
                configurableEnvironment.getPropertySources().addFirst(propertySource);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

}
