/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaAutoServiceRegistration;
import org.springframework.context.event.EventListener;

public class EurekaAutoServiceRegistrationPostProcessor
implements SpecifiedBeanPostProcessor<EurekaAutoServiceRegistration> {
    private static final Logger logger = LoggerFactory.getLogger(EurekaAutoServiceRegistrationPostProcessor.class);

    @Override
    public Class<EurekaAutoServiceRegistration> getBeanType() {
        return EurekaAutoServiceRegistration.class;
    }

    @Override
    public Object postProcessBeforeInitialization(EurekaAutoServiceRegistration bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(EurekaAutoServiceRegistration bean, String beanName) throws BeansException {
        boolean canAop = true;
        try {
            Class.forName("org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent");
            Class.forName("javax.servlet.Servlet");
            Method method = EurekaAutoServiceRegistration.class.getDeclaredMethod("onApplicationEvent", EmbeddedServletContainerInitializedEvent.class);
            EventListener el = method.getAnnotation(EventListener.class);
            if (el == null || el.value() == null || el.value().length != 1 || !el.value()[0].equals(EmbeddedServletContainerInitializedEvent.class)) {
                canAop = false;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            canAop = false;
        }
        if (!canAop) {
            logger.warn("\u68c0\u6d4b\u5230\u6ca1\u6709\u542f\u7528web container\uff0c\u4e0d\u4f1a\u81ea\u52a8\u542f\u7528\u5ef6\u8fdf\u6ce8\u518ceureka\u7279\u6027");
            return bean;
        }
        ProxyFactory proxy = new ProxyFactory();
        proxy.setTarget((Object)bean);
        proxy.addAdvice((Advice)new EurekaAutoServiceRegistrationMethodInterceptor());
        return proxy.getProxy();
    }

    public int getOrder() {
        return 0;
    }

    private static class EurekaAutoServiceRegistrationMethodInterceptor
    implements MethodInterceptor {
        private EurekaAutoServiceRegistrationMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().getName().equals("isAutoStartup")) {
                return false;
            }
            return invocation.proceed();
        }
    }
}

